
 
; Heater controller
; uses control knob for temperature setting
; Thermopile for temperature measurement (includes sensor thermistor)


    ERRORLEVEL -302
    ERRORLEVEL -306

    list P=12F675
    #include P12F675.inc

;Program Configuration Register 
    __CONFIG    _CPD_OFF & _CP_OFF & _BODEN_OFF & _MCLRE_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT	

; RAM 
W_TMP			equ	H'20'	; temporary store for w in interrupt
STATUS_TMP	equ	H'21'	; temporary store of status in interrupt 
STORE1			equ	H'22'	; delay counter	
STORE2		equ	H'23'	; delay counter
STORE3			equ	H'24'	; delay counter
SETTING		equ	H'25'	; temperature or % setting by VR1 
TEMP			equ	H'26'	; temporary
THERMOTOT0	equ	H'27'	; Thermopile reading from amplifier including that due to thermistor offset. ms byte
THERMOTOT1	equ	H'28'	; Thermopile reading from amplifier including that due to thermistor offset. ls byte
SETTING_WORK	equ	H'29'	; use setting working value each cycle
TEMP_DRV		equ	H'2A'	; temperature drive
THERMOPILE0	equ	H'2B'	; thermopile itself that could be + or - from ambient. ms byte
THERMOPILE1	equ	H'2C'	; thermopile itself that could be + or - from ambient. ls byte
AMBIENT		equ	H'2D'	; calculated ambient temperature from thermistor
NEGATIVE		equ	H'2E'	; thermopile sign (+ or- )	
THERMO_T		equ	H'2F'	; thermopile calculated temperature
ACTUAL_T		equ	H'30'	; actual temperature measured
START_FLG		equ	H'31'	; A/D values read flag
PULSE			equ	H'32'	; gate pulses flag
P_COUNT		equ	H'33'	; Pulse count sets angle of waveform for end of gate pulses
CYCLE_9		equ	H'34'	; count waveform cycle 
GATE			equ	H'35'	; first pulse flag
INTER_STRT		equ	H'36'	; interrupt start counter
CYCLE			equ	H'37'	; cycle drives
TIMER			equ	H'38'	; timer0 count
READ_RATE	equ	H'39'	; read rate	
DO_A_D		equ	H'3A'	; do A/D conversion flag
DRV			equ	H'3B'	; gate drive flag
NO_DRV		equ	H'3C'	; no gate drive when reading temperature
TIMER0			equ	H'3D'	; timer0 value

; ******************************************************************

; start at memory 0

    org		0			; reset vector
    goto	MAIN
; interrupt vector
    org		4
    goto	INTERRUPT

;_________________________________________________________________________

; Lookup table for ambient temperature
TEMP_CALC
;
; return value is degrees C based on A/D value from  voltage divider with 100k pullup to A?D reference (5.1V)  and thermistor to 0V.
; (NTC thermistor is 100k at 25 deg C and with a Beta of 3960)
    movwf	TEMP
; check if over 196
    sublw	D'196'
    btfss	STATUS,C
    retlw	D'0'			; less than 0 degrees C.

; subtract 50 from w (start at A/D value for 60 degrees C)

    movlw	D'50'
    subwf	TEMP,w
    btfss	STATUS,C	; if clear (ie less than 50) return with D'60'
    retlw	D'60'		; maximum 60 degrees even if it is more
    addwf	PCL,f		; add to program counter
    retlw	D'60'		; for A/D of 50
    retlw	D'59'		; for A/D of 51
    retlw	D'59'		; for A/D of 52
    retlw	D'58'		; for A/D of 53
    retlw	D'57'		; for A/D of 54
    retlw	D'57'		; for A/D of 55
    retlw	D'56'		; for A/D of 56
    retlw	D'55'		; for A/D of 57
    retlw	D'55'		; for A/D of 58
    retlw	D'54'		; for A/D of 59
    retlw	D'54'		; for A/D of 60
    retlw	D'53'		; for A/D of 61
    retlw	D'52'		; for A/D of 62
    retlw	D'52'		; for A/D of 63
    retlw	D'51'		; for A/D of 64
    retlw	D'51'		; for A/D of 65
    retlw	D'50'		; for A/D of 66
    retlw	D'50'		; for A/D of 67
    retlw	D'49'		; for A/D of 68
    retlw	D'49'		; for A/D of 69
    retlw	D'48'		; for A/D of 70
    retlw	D'48'		; for A/D of 71
    retlw	D'47'		; for A/D of 72
    retlw	D'47'		; for A/D of 73
    retlw	D'46'		; for A/D of 74
    retlw	D'46'		; for A/D of 75
    retlw	D'45'		; for A/D of 76
    retlw	D'45'		; for A/D of 77
    retlw	D'44'		; for A/D of 78
    retlw	D'44'		; for A/D of 79
    retlw	D'43'		; for A/D of 80
    retlw	D'43'		; for A/D of 81
    retlw	D'42'		; for A/D of 82
    retlw	D'42'		; for A/D of 83
    retlw	D'41'		; for A/D of 84
    retlw	D'41'		; for A/D of 85
    retlw	D'41'		; for A/D of 86
    retlw	D'40'		; for A/D of 87
    retlw	D'40'		; for A/D of 88
    retlw	D'39'		; for A/D of 89
    retlw	D'39'		; for A/D of 90
    retlw	D'38'		; for A/D of 91
    retlw	D'38'		; for A/D of 92
    retlw	D'38'		; for A/D of 93
    retlw	D'37'		; for A/D of 94
    retlw	D'37'		; for A/D of 95
    retlw	D'36'		; for A/D of 96
    retlw	D'36'		; for A/D of 97
    retlw	D'36'		; for A/D of 98
    retlw	D'35'		; for A/D of 99
    retlw	D'35'		; for A/D of 100
    retlw	D'34'		; for A/D of 101
    retlw	D'34'		; for A/D of 102
    retlw	D'34'		; for A/D of 103
    retlw	D'33'		; for A/D of 104
    retlw	D'33'		; for A/D of 105
    retlw	D'32'		; for A/D of 106
    retlw	D'32'		; for A/D of 107
    retlw	D'32'		; for A/D of 108
    retlw	D'31'		; for A/D of 109
    retlw	D'31'		; for A/D of 110
    retlw	D'31'		; for A/D of 111
    retlw	D'30'		; for A/D of 112
    retlw	D'30'		; for A/D of 113
    retlw	D'29'		; for A/D of 114
    retlw	D'29'		; for A/D of 115
    retlw	D'29'		; for A/D of 116
    retlw	D'28'		; for A/D of 117
    retlw	D'28'		; for A/D of 118
    retlw	D'28'		; for A/D of 119
    retlw	D'27'		; for A/D of 120
    retlw	D'27'		; for A/D of 121
    retlw	D'27'		; for A/D of 122
    retlw	D'26'		; for A/D of 123
    retlw	D'26'		; for A/D of 124
    retlw	D'26'		; for A/D of 125
    retlw	D'25'		; for A/D of 126
    retlw	D'25'		; for A/D of 127
    retlw	D'24'		; for A/D of 128
    retlw	D'24'		; for A/D of 129
    retlw	D'24'		; for A/D of 130
    retlw	D'23'		; for A/D of 131
    retlw	D'23'		; for A/D of 132
    retlw	D'23'		; for A/D of 133
    retlw	D'22'		; for A/D of 134
    retlw	D'22'		; for A/D of 135
    retlw	D'22'		; for A/D of 136
    retlw	D'21'		; for A/D of 137
    retlw	D'21'		; for A/D of 138
    retlw	D'21'		; for A/D of 139
    retlw	D'20'		; for A/D of 140
    retlw	D'20'		; for A/D of 141
    retlw	D'20'		; for A/D of 142
    retlw	D'19'		; for A/D of 143
    retlw	D'19'		; for A/D of 144
    retlw	D'19'		; for A/D of 145
    retlw	D'18'		; for A/D of 146
    retlw	D'18'		; for A/D of 147
    retlw	D'18'		; for A/D of 148
    retlw	D'17'		; for A/D of 149
    retlw	D'17'		; for A/D of 150
    retlw	D'17'		; for A/D of 151
    retlw	D'16'		; for A/D of 152
    retlw	D'16'		; for A/D of 153
    retlw	D'16'		; for A/D of 154
    retlw	D'15'		; for A/D of 155
    retlw	D'15'		; for A/D of 156
    retlw	D'15'		; for A/D of 157
    retlw	D'14'		; for A/D of 158
    retlw	D'14'		; for A/D of 159
    retlw	D'14'		; for A/D of 160
    retlw	D'13'		; for A/D of 161
    retlw	D'13'		; for A/D of 162
    retlw	D'12'		; for A/D of 163
    retlw	D'12'		; for A/D of 164
    retlw	D'12'		; for A/D of 165
    retlw	D'11'		; for A/D of 166
    retlw	D'11'		; for A/D of 167
    retlw	D'11'		; for A/D of 168
    retlw	D'10'		; for A/D of 169
    retlw	D'10'		; for A/D of 170
    retlw	D'10'		; for A/D of 171
    retlw	D'9'			; for A/D of 172
    retlw	D'9'			; for A/D of 173
    retlw	D'9'			; for A/D of 174
    retlw	D'8'			; for A/D of 175
    retlw	D'8'			; for A/D of 176
    retlw	D'7'			; for A/D of 177
    retlw	D'7'			; for A/D of 178
    retlw	D'7'			; for A/D of 179
    retlw	D'6'			; for A/D of 180
    retlw	D'6'			; for A/D of 181
    retlw	D'5'			; for A/D of 182
    retlw	D'5'			; for A/D of 183
    retlw	D'5'			; for A/D of 184
    retlw	D'4'			; for A/D of 185
    retlw	D'4'			; for A/D of 186
    retlw	D'4'			; for A/D of 187
    retlw	D'3'			; for A/D of 188
    retlw	D'3'			; for A/D of 189
    retlw	D'3'			; for A/D of 190
    retlw	D'2'			; for A/D of 191
    retlw	D'2'			; for A/D of 192
    retlw	D'1'			; for A/D of 193
    retlw	D'1'			; for A/D of 194
    retlw	D'0'			; for A/D of 195
    retlw	D'0'			; for A/D of 196
    retlw	D'0'			; for A/D of 197

; CYCLE drive
CYCLE_DRIVES

    movf	CYCLE,w		; position in cycle 1-30 cycles
    addwf	PCL,f			; add to program counter
    nop						; cycle is 1-30	
    goto	ONE			; ultimately returns with 0 or 1 in 'w'. 0 is gate off, 1 is gate on flag
    goto	TWO
    goto	THREE
    goto	FOUR
    goto	FIVE
    goto 	SIX
    goto	SEVEN
    goto	EIGHT
    goto	NINE
    goto	TEN
    goto	ELEVEN
    goto	TWELVE
    goto	THIRTEEN
    goto	FOURTEEN
    goto	FIFTEEN
    goto	SIXTEEN
    goto	SEVENTEEN
    goto	EIGHTEEN
    goto	NINETEEN
    goto	TWENTY
    goto	TWENTYONE
    goto	TWENTYTWO
    goto	TWENTYTHREE
    goto	TWENTYFOUR
    goto	TWENTYFIVE
    goto	TWENTYSIX
    goto	TWENTYSEVEN
    goto	TWENTYEIGHT
    goto	TWENTYNINE
    goto	THIRTY

 ;____________________________________________________________________________

INTERRUPT
    movwf	W_TMP			; w to w_tmp storage
    swapf	STATUS,w		; status to w
    movwf	STATUS_TMP	; status in status_tmp  
    bcf		STATUS,RP0	; select memory bank 0

    btfsc	CYCLE_9,1		; count waveform cycle for NINETY, if clear get timer0 count from edge to edge
    goto	RUN

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
CALIBRATION; at power up 

; calibrate values for multiplier and angle degrees value
    btfss	INTCON,GPIF		; GP2 port change 
    goto	RECLAIM
    movf	GPIO,w				; read to clear mismatch plus check GP2 Level
    bcf		INTCON,GPIF
    btfsc 	GPIO,2
    goto 	RECLAIM
; If CYCLE_9 ,0 is clear then clear timer1
    btfss	CYCLE_9,0		; count waveform cycle
    goto	WAIT_NEXT_EDGE
; get timer1 count
    bcf		T1CON,0		; stop timer 1

;  timer1 count from edge to edge 
; get timer0 count to set triggering 500us before next edge
    bcf		STATUS,C		; clear carry
    rrf		TMR1H,f			; 
    rrf		TMR1L,f			; /2
    bcf		STATUS,C		; clear carry
    rrf		TMR1H,f			; 
    rrf		TMR1L,f			; /4
    bcf		STATUS,C		; clear carry
    rrf		TMR1H,f			; 
    rrf		TMR1L,f			; /8
    bcf		STATUS,C		; clear carry
    rrf		TMR1H,f			; 
    rrf		TMR1L,f			; /16
    movf	TMR1L,w
    movwf	TIMER0
    comf	TMR1L,w
    addlw	D'4'				; 64us per value. Adjustment for firing due to phase lag in mains sync filter
    movwf	TIMER
    movwf	TMR0

    bsf		T1CON,0		; start timer1 again
; enable interrupts
    bsf		STATUS,RP0	; select memory bank 1
    bsf		PIE1,TMR1IE		; timer 1 overflow interrupt
    bcf		STATUS,RP0	; select memory bank 0
    bsf		INTCON,PEIE	; enable periperal interrupts 
    bcf		PIR1,TMR1IF		; timer 1 interrupt flag
    bsf		INTCON,T0IE		; timer 0
    bcf		INTCON,T0IF
    bsf		CYCLE_9,1		; enable normal run
    goto	RECLAIM
WAIT_NEXT_EDGE
    clrf 		TMR1L			; cleared on edge
    clrf		TMR1H
    bsf		CYCLE_9,0		; set bit 0
    goto	RECLAIM

;>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

; check which interrupt	
RUN	
    btfsc	PIR1,TMR1IF		; timer 1 interrupt flag
    goto	T1	
    btfsc	INTCON,T0IF		; timer 0 over 
    goto	EDGE
    btfss	INTCON,GPIF	; GP2 port change interrupt flag 
    goto	RECLAIM
; mains sync signal
    movf	GPIO,w			; clear mismatch
    bcf		INTCON,GPIF	; flag cleared
    movf	TIMER,w
    movwf	TMR0
    goto	RECLAIM

EDGE
;  (GP2)	
;  timer0 flag clear
    bcf		INTCON,T0IF
    movlw	D'2'
    movwf	P_COUNT		; gate pulses counter 
    clrw
    movwf	GPIO			; gate off at bit 5 (GP5)
    clrf		PULSE
    clrf		GATE
    clrf		TMR1L
    clrf		TMR1H

; reduce read rate counter to 0	
    movf	READ_RATE,w
    btfss	STATUS,Z
    decf	READ_RATE,f			

; check if % or temperature
    btfsc	GPIO,3			; if high it is %
    goto	PERCENTAGE
;_____________________________________________________________

TEMPERATURE
; SETTING has is degrees C required (15-31 degrees C)
; ACTUAL_T is measured temperature
; If setting below actual; stop drive
; If setting higher than actual; drive TRIAC
    movf	SETTING,w
    subwf	ACTUAL_T,w
    btfsc	STATUS,C		; if negative then stop drive
    goto	ACTUAL_GREATER_THAN_SETTING

; Actual temperature is less than setting
; check if <0.5 degree
    movlw	D'1'
    subwf	SETTING,w
    subwf	ACTUAL_T,w
    btfss	STATUS,C
    goto	ONE_LESS
    movlw	D'10'
    goto	CHK1
; check if <1 degree
ONE_LESS
    movlw	D'2'
    subwf	SETTING,w
    subwf	ACTUAL_T,w
    btfss	STATUS,C
    goto	FULL
    movlw	D'20'
    goto	CHK1
FULL
    movlw	D'30'			; fully on value
    goto	CHK1

ACTUAL_GREATER_THAN_SETTING

; check if >0.5 degree
    movf	SETTING,w
    addlw	D'1'
    subwf	ACTUAL_T,w
    btfsc	STATUS,C		; if still negative stop drive
    goto	ONE_MORE
    movlw	D'7'
    goto	CHK1
; check if >1 degree
ONE_MORE
    movf	SETTING,w
    addlw	D'2'
    subwf	ACTUAL_T,w
    btfsc	STATUS,C		; if still negative stop drive
    goto	STOP
    movlw	D'4'
    goto	CHK1
STOP
    clrw					; fully off value
CHK1
    movwf	TEMP_DRV

; check cycle burst
; number of full cycles driven in 15 (30 half ycles)	
; check setting value
    movf	CYCLE,w		; check cycle status
    btfss	STATUS,Z		; if clear restore with original value
    goto	CYC_VIEW
    movlw	D'30'
    movwf	CYCLE
    movf	TEMP_DRV,w	; temperature drive
    movwf	SETTING_WORK	; use working value each cycle
    bcf		STATUS,C
    rrf		SETTING_WORK,f	; divide by 2 for 0-15 range
    goto	CYC_VIEW
;_____________________________________________________________ 

PERCENTAGE
; check cycle burst
; cycles in 15	
; check setting value
    movf	CYCLE,w		; check cycle status
    btfss	STATUS,Z		; if clear restore with original value
    goto	CYC_VIEW
    movlw	D'30'
    movwf	CYCLE
    movf	SETTING,w		; potentiometer VR1 setting
    movwf	SETTING_WORK	; use working value each cycle
    bcf		STATUS,C
    rrf		SETTING_WORK,f	; divide by 2 for 0-15 range
; check if drive needed
CYC_VIEW
    call		CYCLE_DRIVES
    xorlw	D'1'				; if w is 1 the gate drive required. if 0 no gate drive
    btfss	STATUS,Z		; if not =1 no gate drive
    goto	OFF
;on
    decf	CYCLE,f
    bsf		DRV,0			; gate on flag
    goto	GTE_DRV		; drive gate
OFF
    decf	CYCLE,f
    clrw
    movwf	GPIO			; gate off
    clrf		PULSE			; flag for gate pulses
    bcf		DRV,0			; gate off flag
    goto	GTE_DRV		; 
		
T1 ; timer1 overflow	
    bcf		PIR1,TMR1IF		; timer 1 interrupt flag
GTE_DRV
    btfss	START_FLG,0	;  read flag. If  flag is set then A/D values having been read then continue, otherwise exit
    goto	RECLAIM

CHK_PULSES
    btfsc	PULSE,0
    goto	PULSE_OFF

; drive gate at timer overflow

    movf	P_COUNT,w
    btfsc	STATUS,Z
    goto	BY				; bypass gate drive when 0
    decfsz	P_COUNT,f
    goto	CONT
BY	clrw	
    movwf	GPIO
    goto	INC_PULSE	
; check if startup period has ended
CONT
    movf	INTER_STRT	,w	; interrupt start counter
    btfsc	STATUS,Z		; if zero then can drive gate
    goto	DRIVE
    decfsz	INTER_STRT,f	; decrease until zero
    goto	INC_PULSE		; bypass drive
DRIVE
    clrw					; 0 for bit 5 in 'w'
    btfss	NO_DRV,0		; if clear then reading temperature
    goto	MOVE_TO		
    btfsc	DRV,0			; if set use bit 5 on in 'w'
    movlw	B'00100000'		; set bit 5

MOVE_TO
    movwf	GPIO			; gate drive 
INC_PULSE
    incf		PULSE,f			; once first fired alternate on and off
    bsf		GATE,0			; set after first gate pulse

; check pulse number
    movf	P_COUNT,w
    xorlw	D'1'				; compare with first pulse
    btfsc	STATUS,Z
    goto	WIDE

;  GP2 for positive or negative mains cycle
    btfss	GPIO,2
    bsf		DO_A_D,0		; set read analog inputs flag on negative waveform at 90 degrees for thermopile	
    btfsc	GPIO,2
    bsf		DO_A_D,1		; set read analog inputs flag on positive waveform at 90 degrees for thermistor and VR1
    goto	RECLAIM

WIDE
; reload for 300us
    bcf		T1CON,0		; stop timer 1
    movlw	H'DF'			; H'EB' for 200us, H' FE'  for 40us and use H'F7' for 100us or H'DF' for 300us, D3 for 400us 
    movwf	TMR1L
    movlw	H'FF'
    movwf	TMR1H
    bsf		T1CON,0		; start timer 1
    goto	RECLAIM

PULSE_OFF
    clrf		PULSE			; 
    clrw
    movwf	GPIO			; gate off
; reload for 90 degrees after gate on

; check for 50Hz or 60Hz
    movf	TIMER0,w
    sublw	D'143'			; @ 50Hz timer0 is about 156, @ 60Hz is 130 so use intermediate value of 143 to compare
    btfsc	STATUS,C
    goto	SIXTYHz
; 50Hz
    bcf		T1CON,0		; stop timer 1
    movlw	H'D0'			;  for around 90 degrees
    movwf	TMR1L
    movlw	H'FD'			; 
    movwf	TMR1H
    bsf		T1CON,0		; start timer 1
    goto	RECLAIM
SIXTYHz
    bcf		T1CON,0		; stop timer 1
    movlw	H'20'			; about 90 degrees
    movwf	TMR1L
    movlw	H'FE'
    movwf	TMR1H
    bsf		T1CON,0		; start timer 1
; end of interrupt reclaim w and status 

RECLAIM
    swapf	STATUS_TMP,w	; status temp storage to w
    movwf	STATUS			; w to status register
    swapf	W_TMP,f		; swap upper and lower 4-bits in w_tmp
    swapf  	W_TMP,w		; swap bits and into w register
    retfie					; return from interrupt

; ***********************************************************
		
MAIN
; set oscillator calibration
    bsf		STATUS,RP0	; bank 1
    call		H'3FF'			; oscillator calibration value
    movwf	OSCCAL
    bcf		STATUS,RP0	; select memory bank 0

; set inputs/outputs
    movlw	B'00000000'
    movwf	GPIO			; ports low
    movlw	B'00000111'		; comparators off
    movwf	CMCON
    bsf		STATUS,RP0	; select memory bank 1
    movlw	B'00000000'		; pullups off
    movwf	WPU
    movlw	B'00011111'		; outputs/inputs set 
    movwf	TRISIO			; port data direction register
    movlw	B'00000101'		; settings (pullups disabled) timer0 /64 prescaler
    movwf	OPTION_REG
; analog inputs, A/D
    movlw	B'01011011'
    movwf	ANSEL			; digital I/O and analog at AN0

    bcf		STATUS,RP0	; select memory bank 0
    movlw	B'00000000'		; channel 0, left justified, VDD ref etc

    movwf	ADCON0
    bsf		ADCON0,ADON	; A/D on

;Timer1 on
    movlw 	B'00110001'		; divide by 8 for 8us per count
    movwf	T1CON

;  initial states
    clrf		SETTING
    clrf		START_FLG
    clrf		TMR1L			; timer1 clear
    clrf		TMR1H
    movlw	D'10'
    movwf	INTER_STRT		; interrupt start counter
    clrf		CYCLE_9		; count waveform cycle 
    movlw	D'32'			; half cycles
    movwf	CYCLE			; cycle counter
    clrf		SETTING_WORK	;  working value of setting  each cycle
    clrf		TEMP_DRV		; temperature drive
    clrf		DO_A_D		; do A/D conversion flag
    movlw	D'255'
    movwf	READ_RATE	; A/D read rate for thermistor and thermopile, initial is 255 x 10ms = 2.55s for 50Hz mains

; Startup timer
    movlw	D'200'			; 4s
    movwf	TEMP
STRT_DEL
    call		DELAYms		; 20ms approx
    decfsz	TEMP,f
    goto	STRT_DEL		; startup delay

; Interrupts
    bsf		STATUS,RP0	; select memory bank 1
    bsf		IOC,2			; port change on GP2		
    bcf		STATUS,RP0	; select memory bank 0

    bsf		INTCON,GPIE	; enable port change interrrupt
    bcf		INTCON,GPIF	;  flag	 
    bsf 		INTCON,GIE		; set global interrupt enable 

UPDATE

; read A/D
;bits 3-2 CHS1:CHS0: Analog Channel Select bits
;00 = Channel 00 (AN0) 

; check read rate
    movf	READ_RATE,w
    btfss	STATUS,Z
    goto	 SETTING_POT

;Thermopile amplified signal
    clrf		DO_A_D		; do A/D conversion flag

    btfss	START_FLG,1	; if clear then bypass DO_A_D flag check 
    goto	BY_WAIT1
; wait till set
WAIT1
    btfss	DO_A_D,1		;  A/D conversion flag wait for flag from interrupt
    goto	WAIT1
BY_WAIT1
    bcf		ADCON0,2		; 
    bcf		ADCON0,3		; channel 0
    call		DELAYX
    call		ACQUIRE_AD

; disconnect thermopile
    bsf		ADCON0,2

    movf	ADRESH,w
    movwf	THERMOTOT1	; thermopile total level after amplification plus offset 

; get ls bits from A/D
    bsf		STATUS,RP0	; select memory bank 1
    movf	ADRESL,w		; bits 9 and 10 lsb
    bcf		STATUS,RP0	; select memory bank 0
    movwf	TEMP			; lsb
    clrf		THERMOTOT0	

; shift TEMP into THERMOTOT1  and then THERMOTOT0 for 10-bit 1024 value range
    rlf		TEMP,f
    rlf		THERMOTOT1,f
    rlf		THERMOTOT0,f	
    rlf		TEMP,f
    rlf		THERMOTOT1,f
    rlf		THERMOTOT0,f

THERMISTOR
; Thermistor

    clrf		DO_A_D		; do A/D conversion flag
    btfss	START_FLG,0	; if clear then bypass DO_A_D flag check 
    goto	BY_WAIT3
; wait till set
WAIT3
    btfss	DO_A_D,1		; do A/D conversion flag
    goto	WAIT3
BY_WAIT3
;11 = Channel 03 (AN3) 
    bsf		ADCON0,2		; 
    bsf		ADCON0,3		; channel 3
    call		DELAYX
    call		ACQUIRE_AD
    movf	ADRESH,w

    bcf		ADCON0,3		; disconnect channel 3

; use lookup thermistor table for its temperature
    call		TEMP_CALC	; get AMBIENT temperature
    movwf	AMBIENT		; Thermistor measured ambient for thermopile sensor
    bcf		STATUS,C
    rlf		AMBIENT,f		; x 2

; Calculations

; test thermopile range
; >H2FF and <H100
; test for a 3 (>2FF)
    movlw	H'03'
    xorwf	THERMOTOT0,w
    btfss	STATUS,Z			; if zero, use 00 in THERMOPILE1
    goto	CK_NXT
    clrf		THERMOPILE1
    bcf		NEGATIVE,0			; positive so adds to ambient
    goto	VALUE
CK_NXT
    movf	THERMOTOT0,w
    btfsc	STATUS,Z			; if a zero use FF in THERMOPILE1
    goto	SETF
; test for THERMOTOT1 if a zero
    movf	THERMOTOT1,w
    btfss	STATUS,Z			; if zero test for THERMOTOT0 for a 0 or 1
    goto	SUBT
; test THERMOTOT1 for a 1
    movlw	H'01'
    xorwf	THERMOTOT0,w
    btfss	STATUS,Z
    goto	SUBT	
    SETF
    movlw	H'FF'
    movwf	THERMOPILE1
    bsf		NEGATIVE,0			; negative so subtracts from ambient
    goto	VALUE

SUBT
; remove offset from thermopile reading
; that is 1/2 of the supply at H200 for 10-bit A/D

; subtract (H200-THERMOTOT)
    bsf		NEGATIVE,0				; set negative flag
    movf   	THERMOTOT0,w 	 		 ; high byte 
    sublw   	H'02'		  			 ; subtract high byte
    movwf	THERMOPILE0
    movf	THERMOTOT1,w
    sublw	H'00'
    movwf	THERMOPILE1
    btfss	STATUS,C
    decf	THERMOPILE0,f
; test for greater
    btfss	THERMOPILE0,7
    goto	VALUE
; use THERMOTOT1
    movf	THERMOTOT1,w
    movwf	THERMOPILE1
    bcf		NEGATIVE,0

; convert thermopile value to temperature (thermo_T). Thermoplile is 124uV/deg C
; assuming amplifier gain of around 81 we set output at 10mV/degrees C. ie for 10-bit A/D then each bit is 0.5 degrees C 
; gain of 162 is required for a differential amplifier as thermopile is single ended output and so  requires twice the gain settiing. 
; however gain needs adjusting for losses through HDPE lens and acceptance angle. 
VALUE
    movf	THERMOPILE1,w
    movwf	THERMO_T

; add or subtract 'thermoT' to/from 'ambient' depending on negative flag

; if  NEGATIVE,0 is set take THERMO_T from AMBIENT
; if NEGATIVE is clear then add

    btfss	NEGATIVE,0
    goto	ADD
    movf	THERMO_T,w		; thermopile calculated temperature
    subwf	AMBIENT,w
    btfss	STATUS,C			; if negative set at 0
    clrw	
    movwf	ACTUAL_T			; actual temperature measured from thermistor and thermopile values
    goto	TEMP_CALCULATED
    ADD
    movf	THERMO_T,w		; thermopile calculated temperature
    addwf	AMBIENT,w
    btfsc	STATUS,C
    movlw	H'FF'				; if over then use FF
    movwf	ACTUAL_T			; actual temperature measured from thermistor and thermopile values	

TEMP_CALCULATED
    bsf		START_FLG,0		;  Set flag as values having been read
; allow gate drive
    bsf		NO_DRV,0
    movlw	D'100'
    movwf	READ_RATE

SETTING_POT; (temperature or %)
;01 = Channel 01 (AN1) 

    clrf		DO_A_D		; do A/D conversion flag
    btfss	START_FLG,0	; if clear then bypass DO_A_D flag check 
    goto	BY_WAIT2
; wait till set
WAIT2
    btfss	DO_A_D,0		; do A/D conversion flag
    goto	WAIT2
BY_WAIT2
    bsf		ADCON0,2		; channel 1
    bcf		ADCON0,3		; 
    call		DELAYX
    call		ACQUIRE_AD

; check if % or degrees C
    btfss	GPIO,3
    goto	TEMP_SETTING
; %, divide by 8
    bcf		STATUS,C
    rrf		ADRESH,f
    bcf		STATUS,C
    rrf		ADRESH,f
    bcf		STATUS,C
    rrf		ADRESH,w
    andlw	B'11111110'		; clear bit 0 for all even values so even number of cycles driven
    movwf	SETTING		;  % 0-30

    goto	UPDATE

TEMP_SETTING
; for range from 15 to 31 degrees. divide ADRESH by 16, add 15
    bcf		STATUS,C
    rrf		ADRESH,f		; 2
    bcf		STATUS,C
    rrf		ADRESH,f		; 4
    bcf		STATUS,C
    rrf		ADRESH,f		; 8
    bcf		STATUS,C
    rrf		ADRESH,w		; 16
    addlw	D'15'
    movwf	SETTING		; temperature 15 to 31 

    bcf		STATUS,C
    rlf		SETTING,f		; x 2  

    goto	UPDATE

; *****************************************************************************************************************************************************
; subroutines

; subroutine to wait for A/D conversion
ACQUIRE_AD
    bsf		ADCON0,GO_DONE	; GO/DONE bit start conversion
WAIT_CONV
    btfsc	ADCON0,GO_DONE	; conversion complete when cleared ~11 cycles
    goto	WAIT_CONV
    return

; delay loop 
; 10.87ms
DELAYms
    movlw	D'23'		; delay value
    movwf	STORE1		; STORE1 is number of loops value
LOOP8	
    movlw	D'117'
    movwf	STORE2		; STORE2 is internal loop value	
LOOP9
    clrwdt
    decfsz	STORE2,f
    goto	LOOP9
    decfsz	STORE1,f
    goto	LOOP8
    return

DELAYX
    movlw	D'30'
    movwf	STORE1		; STORE1 is  loop value	
LOOP1
    decfsz	STORE1,f
    goto	LOOP1
    return

; gate drive sequence 

; Setting (down 15 to 1), Cycle number (1 to 30 across)
; Gate drive to + is one half of mains waveform cycle,  is the other half of mains waveform cycle. Blank is no drive

;(can copy and past table below into a word file and reconstruct as a table (ie Table/convert text to table))
;1;2;3;4;5;6;7;8;9;10;11;12;13;14;15;16;17;18;19;20;21;22;23;24;25;26;27;28;29;30
;15;+;-;+;-;+;-;+;-;+;-;+;-;+;-;+;-;+;-;+;-;+;-;+;-;+;-;+;-;+;-
;14;+;-;+;-;+;-;+;-;+;-;+;-;+;-;;;+;-;+;-;+;-;+;-;+;-;+;-;+;-
;13;+;-;+;-;+;-;;;+;-;+;-;+;-;+;-;+;-;+;-;+;-;;;+;-;+;-;+;-
;12;+;-;+;-;;;+;-;+;-;+;-;+;-;;;+;-;+;-;+;-;+;-;;;+;-;+;-
;11;+;-;;;+;-;+;-;+;-;;;+;-;+;-;+;-;;;+;-;+;-;+;-;;;+;-
;10;+;-;;;+;-;+;-;;;+;-;+;-;;;+;-;+;-;;;+;-;+;-;;;+;-
;9;+;-;;;+;-;;;+;-;+;-;;;+;-;;;+;-;+;-;;;+;-;;;+;-
;8;+;-;;;+;-;;;+;-;;;+;-;;;+;-;;;+;-;;;+;-;;;+;-
;7;;;+;-;;;;;+;-;;;+;-;;;+;-;;;+;-;;;+;-;;;+;-
;6;;;+;-;;;+;-;;;;;+;-;;;+;-;;;;;+;-;;;+;-;;
;5;;;+;-;;;;;+;-;;;;;+;-;;;;;+;-;;;;;+;-;;
;4;;;+;-;;;;;;;+;-;;;;;;;+;-;;;;;;;+;-;;
;3;;;;;+;-;;;;;;;;;+;-;;;;;;;;;+;-;;;;
;2;;;;;;;+;-;;;;;;;;;;;;;;;+;-;;;;;;
;1;;;;;;;;;;;;;;;+;-;;;;;;;;;;;;;;

THIRTY; cycle 30
TWENTYNINE; cycle 29
; drive when setting is 7 or more
    movf	SETTING_WORK,w
    sublw	D'6'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
    retlw	D'0'
TWENTYSEVEN
TWENTYEIGHT
; drive when setting is 12 or more
    movf	SETTING_WORK,w
    sublw	D'11'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
; drive if  4, 5 or 6
    movf	SETTING_WORK,w
    xorlw	D'4'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'5'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'6'
    btfsc	STATUS,Z
    retlw	D'1'
    retlw	D'0'			; no drive
TWENTYFIVE
TWENTYSIX
; no drive if 12
    movf	SETTING_WORK,w
    xorlw	D'12'
    btfsc	STATUS,Z
    retlw	D'0'
; otherwise drive  if 7 or more
    movf	SETTING_WORK,w
    sublw	D'6'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
; drive if 3
    movf	SETTING_WORK,w
    xorlw	D'3'
    btfsc	STATUS,Z
    retlw	D'1'
    retlw	D'0'
TWENTYTHREE
TWENTYFOUR
; no drive if 13
    movf	SETTING_WORK,w
    xorlw	D'13'
    btfsc	STATUS,Z
    retlw	D'0'
; otherwise drive  if 10 or more
    movf	SETTING_WORK,w
    sublw	D'9'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
; drive if  2 or 6
    movf	SETTING_WORK,w
    xorlw	D'2'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'6'
    btfsc	STATUS,Z
    retlw	D'1'
    retlw	D'0'
TWENTYONE
TWENTYTWO
; no drive if 10
    movf	SETTING_WORK,w
    xorlw	D'10'
    btfsc	STATUS,Z
    retlw	D'0'
; otherwise drive  if 7 or more
    movf	SETTING_WORK,w
    sublw	D'6'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
; drive if  5
    movf	SETTING_WORK,w
    xorlw	D'5'
    btfsc	STATUS,Z
    retlw	D'1'
    retlw	D'0'
NINETEEN
TWENTY
; no drive if 11
    movf	SETTING_WORK,w
    xorlw	D'11'
    btfsc	STATUS,Z
    retlw	D'0'
; otherwise drive  if 9 or more
    movf	SETTING_WORK,w
    sublw	D'8'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
; drive if  4
    movf	SETTING_WORK,w
    xorlw	D'4'
    btfsc	STATUS,Z
    retlw	D'1'
    retlw	D'0'
SEVENTEEN
EIGHTEEN
; no drive if 9
    movf	SETTING_WORK,w
    xorlw	D'9'
    btfsc	STATUS,Z
    retlw	D'0'
; drive  if 6 or more
    movf	SETTING_WORK,w
    sublw	D'5'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
    retlw	D'0'
FIFTEEN
SIXTEEN
; drive if 15,13,11,9,5,3 or 1
    movf	SETTING_WORK,w
    xorlw	D'15'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'13'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'11'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'9'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'5'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'3'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'1'
    btfsc	STATUS,Z
    retlw	D'1'
    retlw	D'0'
THIRTEEN
FOURTEEN
; no drive if 9
    movf	SETTING_WORK,w
    xorlw	D'9'
    btfsc	STATUS,Z
    retlw	D'0'
; drive  if 6 or more
    movf	SETTING_WORK,w
    sublw	D'5'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
    retlw	D'0'
ELEVEN
TWELVE
; drive  if 12 or more
    movf	SETTING_WORK,w
    sublw	D'11'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
; drive if  10, 9, or 4
    movf	SETTING_WORK,w
    xorlw	D'10'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'9'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'4'
    btfsc	STATUS,Z
    retlw	D'1'
    retlw	D'0'
NINE
TEN
; no drive if 10
    movf	SETTING_WORK,w
    xorlw	D'10'
    btfsc	STATUS,Z
    retlw	D'0'
; drive  if 7 or more
    movf	SETTING_WORK,w
    sublw	D'6'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
; drive if  5
    movf	SETTING_WORK,w
    xorlw	D'5'
    btfsc	STATUS,Z
    retlw	D'1'
    retlw	D'0'
SEVEN
EIGHT
; no drive if 13
    movf	SETTING_WORK,w
    xorlw	D'13'
    btfsc	STATUS,Z
    retlw	D'0'
; otherwise drive  if 10 or more
    movf	SETTING_WORK,w
    sublw	D'9'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
; drive if  6 or 2
    movf	SETTING_WORK,w
    xorlw	D'6'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'2'
    btfsc	STATUS,Z
    retlw	D'1'
    retlw	D'0'
FIVE
SIX
; no drive if 12
    movf	SETTING_WORK,w
    xorlw	D'12'
    btfsc	STATUS,Z
    retlw	D'0'
; otherwise drive  if 8 or more
    movf	SETTING_WORK,w
    sublw	D'7'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
; drive if 3
    movf	SETTING_WORK,w
    xorlw	D'3'
    btfsc	STATUS,Z
    retlw	D'1'
    retlw	D'0'
THREE
FOUR
; drive  if 12 or more
    movf	SETTING_WORK,w
    sublw	D'11'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
; drive if  7, 6, 5 or 4
    movf	SETTING_WORK,w
    xorlw	D'7'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'6'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'5'
    btfsc	STATUS,Z
    retlw	D'1'
    movf	SETTING_WORK,w
    xorlw	D'4'
    btfsc	STATUS,Z
    retlw	D'1'
    retlw	D'0'
ONE
TWO
; drive  if 8 or more
    movf	SETTING_WORK,w
    sublw	D'7'
    btfss	STATUS,C	; if negative then drive
    retlw	D'1'			; 1 for drive
    retlw	D'0'
	

    end
